unit IWCompRectangle;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing, IWNetClasses,
  {$ELSE}
  Classes,
  {$ENDIF}
  IWContainerBorderOptions,
  IWHTMLTag, IWControl, IWTypes, IWGridCommon, IWColor, IWRenderContext;

type
  TIWCustomRectangle = class(TIWCustomControl)
  private
    procedure BorderOptionsChange(ASender: TObject);
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  protected
    FAlignment: TAlignment;
    FBorderOptions: TIWBorderOptions;
    FVAlign: TIWGridVAlign;
    //
    procedure SetAlignment(const Value: TAlignment);
    procedure SetVAlign(const Value: TIWGridVAlign);
    procedure SetBorderOptions(const Value: TIWBorderOptions);

    procedure InitControl; override;
    function get_HasTabOrder: boolean;override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;

    property Alignment: TAlignment read FAlignment write SetAlignment;
    {$IFDEF VSNET}[DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]{$ENDIF}
    property BorderOptions: TIWBorderOptions read FBorderOptions write SetBorderOptions;
    property VAlign: TIWGridVAlign read FVAlign write SetVAlign;
  published
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Text;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWRectangle.bmp}
  TIWRectangle = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWRectangle), 'TIWRectangle.bmp')]
  {$ENDIF}
  TIWRectangle = class(TIWCustomRectangle)
  published
    property BorderOptions;
    property FriendlyName;
    {$IFDEF CLR}
    property WebColor;
    {$ELSE}
    property Color;
    {$ENDIF}
    property Alignment;
    property VAlign;
  end;

implementation

uses
  {$IFDEF VSNET}
  {$ELSE}
  {$IFDEF Linux}QControls,{$ELSE}Controls,{$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  SysUtils,
  IWServerControllerBase, IWLayoutMgrForm,
  SWSystem;

{ TIWCustomRectangle }

procedure TIWCustomRectangle.InitControl;
begin
  inherited;
  WebColor := fromTColor(clNone);
  Width := 200;
  Height := 100;
  set_RenderSize(true);
  FBorderOptions := IWContainerBorderOptions.TIWBorderOptions.Create;
  FBorderOptions.Control := Self;
  FBorderOptions.OnChange := BorderOptionsChange;
end;

procedure TIWCustomRectangle.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FBorderOptions);
  inherited;
end;

function TIWCustomRectangle.get_HasTabOrder: boolean;
begin
  result:=false;
end;

function TIWCustomRectangle.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Result := TIWHTMLTag.CreateTag('TABLE'); try
    Result.AddColor('BGCOLOR', WebColor);
    Result.AddIntegerParam('WIDTH', Width);
    Result.AddIntegerParam('HEIGHT', Height);
    Result.AddIntegerParam('BORDER', BorderOptions.Width);
    if toTColor(BorderOptions.Color) <> clNone then begin
      Result.AddStringParam('BORDERCOLOR', ColorToRGBString(BorderOptions.Color));
    end;
    Result.AddIntegerParam('CELLPADDING', 0);
    Result.AddIntegerParam('CELLSPACING', 0);
    with Result.Contents.AddTag('TR') do begin
      // AddIntegerParam('HEIGHT', Height);
      with Contents.AddTag('TD') do begin
        // AddIntegerParam('HEIGHT', Height);
        if Text = '' then
          Contents.AddText('') // &nbsp;')
        else begin
          AddStringParam('ALIGN', IWGridAlignments[Alignment]);
          case FVAlign of
            vaMiddle: AddStringParam('VALIGN', 'MIDDLE');
            vaTop: AddStringParam('VALIGN', 'top');
            vaBottom: AddStringParam('VALIGN', 'bottom');
            vaBaseline: AddStringParam('VALIGN', 'basline');
          end;

          Contents.AddText(Text)
        end;
      end;
    end;
  except FreeAndNil(Result); raise; end;
end;

procedure TIWCustomRectangle.SetAlignment(const Value: TAlignment);
begin
  FAlignment := Value;
  Invalidate;
end;

procedure TIWCustomRectangle.SetBorderOptions(const Value: TIWBorderOptions);
begin
  FBorderOptions.Assign(Value);
  Invalidate;
end;

procedure TIWCustomRectangle.BorderOptionsChange(ASender: TObject);
begin
  Invalidate;
end;

procedure TIWCustomRectangle.SetVAlign(const Value: TIWGridVAlign);
begin
  FVAlign := Value;
  Invalidate;
end;


end.
